; Math.s : 数学関数
;


; モジュール宣言
;
    .module Math

; 参照ファイル
;


; CODE 領域
;
    .area   _CODE

; sin の値を取得する
;
_MathGetSin::
    
    ; レジスタの保存
    push    hl

    ; a  < 角度
    ; de > sin 値
    
    ; 値の取得
    ld      d, #0x00
    add     a, a
    rl      d
    ld      e, a
    ld      hl, #trigonometricSinTable
    add     hl, de
    ld      e, (hl)
    inc     hl
    ld      d, (hl)
    
    ; レジスタの復帰
    pop     hl
    
    ; 終了
    ret

; cos の値を取得する
;
_MathGetCos::
    
    ; レジスタの保存
    push    hl
    
    ; a  < 角度
    ; de > cos 値
    
    ; 値の取得
    add     a, #0x40
    ld      d, #0x00
    add     a, a
    rl      d
    ld      e, a
    ld      hl, #trigonometricSinTable
    add     hl, de
    ld      e, (hl)
    inc     hl
    ld      d, (hl)
    
    ; レジスタの復帰
    pop     hl
    
    ; 終了
    ret

; atan2 の値を取得する
;
_MathGetAtan2::
    
    ; レジスタの保存
    push    hl
    push    bc
    push    de
    
    ; hl < Y/X 値
    ; a  > 角度
    
    ; 値の取得
    ld      c, #0x00
    ld      a, h
    sla     h
    rl      c
    bit     #0x00, c
    jr      z, 10$
    neg
    jp      po, 10$
    ld      a, #0x7f
10$:
    ld      h, a
    ld      a, l
    sla     l
    rl      c
    bit     #0x00, c
    jr      z, 11$
    neg
    jp      po, 11$
    ld      a, #0x7f
11$:
    ld      l, a
    cp      h
    jr      nc, 12$
    ld      a, h
12$:
    cp      #0x10
    jr      c, 13$
    sra     a
    sra     l
    sra     h
    jr      12$
13$:
    ld      a, h
    add     a, a
    add     a, a
    add     a, a
    add     a, a
    add     a, l
    ld      e, a
    ld      d, #0x00
    ld      hl, #trigonometricAtanAngleTable
    add     hl, de
    ld      a, (hl)
    ld      b, c
    inc     b
    bit     #0x01, b
    jr      z, 14$
    neg
14$:
    ld      b, #0x00
    ld      hl, #trigonometricAtanOffsetTable
    add     hl, bc
    add     a, (hl)
    
    ; レジスタの復帰
    pop     de
    pop     bc
    pop     hl
    
    ; 終了
    ret

; 定数の定義
;

;  三角関数
;
trigonometricSinTable:
    
    .dw     0x0000, 0x0006, 0x000c, 0x0012, 0x0019, 0x001f, 0x0025, 0x002b, 0x0031, 0x0038, 0x003e, 0x0044, 0x004a, 0x0050, 0x0056, 0x005c
    .dw     0x0061, 0x0067, 0x006d, 0x0073, 0x0078, 0x007e, 0x0083, 0x0088, 0x008e, 0x0093, 0x0098, 0x009d, 0x00a2, 0x00a7, 0x00ab, 0x00b0
    .dw     0x00b5, 0x00b9, 0x00bd, 0x00c1, 0x00c5, 0x00c9, 0x00cd, 0x00d1, 0x00d4, 0x00d8, 0x00db, 0x00de, 0x00e1, 0x00e4, 0x00e7, 0x00ea
    .dw     0x00ec, 0x00ee, 0x00f1, 0x00f3, 0x00f4, 0x00f6, 0x00f8, 0x00f9, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00fe, 0x00ff, 0x00ff, 0x00ff
    .dw     0x0100, 0x00ff, 0x00ff, 0x00ff, 0x00fe, 0x00fe, 0x00fd, 0x00fc, 0x00fb, 0x00f9, 0x00f8, 0x00f6, 0x00f4, 0x00f3, 0x00f1, 0x00ee
    .dw     0x00ec, 0x00ea, 0x00e7, 0x00e4, 0x00e1, 0x00de, 0x00db, 0x00d8, 0x00d4, 0x00d1, 0x00cd, 0x00c9, 0x00c5, 0x00c1, 0x00bd, 0x00b9
    .dw     0x00b5, 0x00b0, 0x00ab, 0x00a7, 0x00a2, 0x009d, 0x0098, 0x0093, 0x008e, 0x0088, 0x0083, 0x007e, 0x0078, 0x0073, 0x006d, 0x0067
    .dw     0x0061, 0x005c, 0x0056, 0x0050, 0x004a, 0x0044, 0x003e, 0x0038, 0x0031, 0x002b, 0x0025, 0x001f, 0x0019, 0x0012, 0x000c, 0x0006
    .dw     0x0000, 0xfffa, 0xfff4, 0xffee, 0xffe7, 0xffe1, 0xffdb, 0xffd5, 0xffcf, 0xffc8, 0xffc2, 0xffbc, 0xffb6, 0xffb0, 0xffaa, 0xffa4
    .dw     0xff9f, 0xff99, 0xff93, 0xff8d, 0xff88, 0xff82, 0xff7d, 0xff78, 0xff72, 0xff6d, 0xff68, 0xff63, 0xff5e, 0xff59, 0xff55, 0xff50
    .dw     0xff4b, 0xff47, 0xff43, 0xff3f, 0xff3b, 0xff37, 0xff33, 0xff2f, 0xff2c, 0xff28, 0xff25, 0xff22, 0xff1f, 0xff1c, 0xff19, 0xff16
    .dw     0xff14, 0xff12, 0xff0f, 0xff0d, 0xff0c, 0xff0a, 0xff08, 0xff07, 0xff05, 0xff04, 0xff03, 0xff02, 0xff02, 0xff01, 0xff01, 0xff01
    .dw     0xff00, 0xff01, 0xff01, 0xff01, 0xff02, 0xff02, 0xff03, 0xff04, 0xff05, 0xff07, 0xff08, 0xff0a, 0xff0c, 0xff0d, 0xff0f, 0xff12
    .dw     0xff14, 0xff16, 0xff19, 0xff1c, 0xff1f, 0xff22, 0xff25, 0xff28, 0xff2c, 0xff2f, 0xff33, 0xff37, 0xff3b, 0xff3f, 0xff43, 0xff47
    .dw     0xff4b, 0xff50, 0xff55, 0xff59, 0xff5e, 0xff63, 0xff68, 0xff6d, 0xff72, 0xff78, 0xff7d, 0xff82, 0xff88, 0xff8d, 0xff93, 0xff99
    .dw     0xff9f, 0xffa4, 0xffaa, 0xffb0, 0xffb6, 0xffbc, 0xffc2, 0xffc8, 0xffcf, 0xffd5, 0xffdb, 0xffe1, 0xffe7, 0xffee, 0xfff4, 0xfffa

trigonometricAtanAngleTable:

    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x40, 0x20, 0x12, 0x0d, 0x09, 0x08, 0x06, 0x05, 0x05, 0x04, 0x04, 0x03, 0x03, 0x03, 0x02, 0x02
    .db     0x40, 0x2d, 0x20, 0x17, 0x12, 0x0f, 0x0d, 0x0b, 0x09, 0x08, 0x08, 0x07, 0x06, 0x06, 0x05, 0x05
    .db     0x40, 0x32, 0x28, 0x20, 0x1a, 0x16, 0x12, 0x10, 0x0e, 0x0d, 0x0b, 0x0a, 0x09, 0x09, 0x08, 0x08
    .db     0x40, 0x36, 0x2d, 0x25, 0x20, 0x1b, 0x17, 0x15, 0x12, 0x11, 0x0f, 0x0e, 0x0d, 0x0c, 0x0b, 0x0a
    .db     0x40, 0x37, 0x30, 0x29, 0x24, 0x20, 0x1c, 0x19, 0x16, 0x14, 0x12, 0x11, 0x10, 0x0e, 0x0d, 0x0d
    .db     0x40, 0x39, 0x32, 0x2d, 0x28, 0x23, 0x20, 0x1c, 0x1a, 0x17, 0x16, 0x14, 0x12, 0x11, 0x10, 0x0f
    .db     0x40, 0x3a, 0x34, 0x2f, 0x2a, 0x26, 0x23, 0x20, 0x1d, 0x1a, 0x18, 0x17, 0x15, 0x14, 0x12, 0x11
    .db     0x40, 0x3a, 0x36, 0x31, 0x2d, 0x29, 0x25, 0x22, 0x20, 0x1d, 0x1b, 0x19, 0x17, 0x16, 0x15, 0x13
    .db     0x40, 0x3b, 0x37, 0x32, 0x2e, 0x2b, 0x28, 0x25, 0x22, 0x20, 0x1d, 0x1b, 0x1a, 0x18, 0x17, 0x16
    .db     0x40, 0x3b, 0x37, 0x34, 0x30, 0x2d, 0x29, 0x27, 0x24, 0x22, 0x20, 0x1e, 0x1c, 0x1a, 0x19, 0x17
    .db     0x40, 0x3c, 0x38, 0x35, 0x31, 0x2e, 0x2b, 0x28, 0x26, 0x24, 0x21, 0x20, 0x1e, 0x1c, 0x1b, 0x19
    .db     0x40, 0x3c, 0x39, 0x36, 0x32, 0x2f, 0x2d, 0x2a, 0x28, 0x25, 0x23, 0x21, 0x20, 0x1e, 0x1c, 0x1b
    .db     0x40, 0x3c, 0x39, 0x36, 0x33, 0x31, 0x2e, 0x2b, 0x29, 0x27, 0x25, 0x23, 0x21, 0x20, 0x1e, 0x1d
    .db     0x40, 0x3d, 0x3a, 0x37, 0x34, 0x32, 0x2f, 0x2d, 0x2a, 0x28, 0x26, 0x24, 0x23, 0x21, 0x20, 0x1e
    .db     0x40, 0x3d, 0x3a, 0x37, 0x35, 0x32, 0x30, 0x2e, 0x2c, 0x29, 0x28, 0x26, 0x24, 0x22, 0x21, 0x20
    
trigonometricAtanOffsetTable:
    
    .db     0x00, 0x80, 0x00, 0x80


; DATA 領域
;
    .area   _DATA

; 変数の定義
;

